/*
 * Les portables Toshiba stocke le mot de passe sous la forme d'un
 * CRC sur 16 bits. La methode usuel pour retrouver un mot de passe
 * valide est de generer des chaines de caracteres, de calculer leurs CRC
 * et enfin de comparer au CRC de reference.
 * Comme la modification d'un bit a une position donne entraine
 * une modification precise du CRC, il serait possible de modifier un mot de
 * passe pour qu'il converge vers le CRC souhaite.
 * Ce programme etablie quels sont les alterations a effectues pour modifier
 * precisement un bit du CRC. Ce faisant, on montre ainsi qu'il est possible de
 * trouver en temps reel et systematiquement une chaine pour tout CRC.
 * */
#define TOSHIBA 1
#include <string.h>
#include <stdio.h>
#ifdef __MSDOS__
#include <dos.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#else
#include <unistd.h>
#include <ctype.h>
#endif
#define MAX_LENGTH_PWD 10
typedef unsigned char      byte;    /* type of 8 bit unsigned quantity */
typedef unsigned short     Bit16u;  /* type of 16 bit unsigned quantity */
typedef unsigned long      Bit32u;  /* type of 32 bit unsigned quantity */
typedef unsigned char 	t_tab[MAX_LENGTH_PWD+1];
byte fr=1;
int table[16][MAX_LENGTH_PWD];

byte scan2ascii(byte car)
{
static const byte tbl_fr[255]=
{ ' ',' ','1','2','3','4','5','6',
  '7','8','9','0',')','=',' ',' ',
  'A','Z','E','R','T','Y','U','I',     /* 10 */
  'O','P',' ','$',' ',' ','Q','S',     /* 18 */
  'D','F','G','H','J','K','L','M',     /* 20 */
  '%','',' ','*','W','X','C','V',
  'B','N',',',';',':','/',' ','*',     /* 30 */
  ' ',' ',' ','f','f','f','f','f',     /* F1 a F10 */
  'f','f','f','f','f',' ',' ','7',     /* 40 */
  '8','9','-','4','5','6','+','1',
  '2','3','0','.',' ',' ','>',' '};    /* 50 */

static const byte tbl_us[255]=
{ ' ',' ','1','2','3','4','5','6',
  '7','8','9','0','-','=',' ',' ',
  'Q','W','E','R','T','Y','U','I',     /* 10 */
  'O','P',' ','$',' ',' ','A','S',     /* 18 */
  'D','F','G','H','J','K','L',';',     /* 20 */
  '','`',' ','*','Z','X','C','V',
  'B','N','M',',','.','/','"','*',     /* 30 */
  ' ',' ',' ','f','f','f','f','f',     /* F1 a F10 */
  'f','f','f','f','f',' ',' ','7',     /* 40 */
  '8','9','-','4','5','6','+','1',
  '2','3','0','.',' ',' ','>',' '};    /* 50 */
/* start */
  if (car<0x58)
  {
    if (fr==1)
      return tbl_fr[car];
    else
      return tbl_us[car];
  }
  else
    return ' ';
}

void aff_bin(int x)
{
		int i;
		for(i=15;i>=0;i--)
		{
		  if(x&(1<<i))
			printf("1");
		  else
			printf("0");
		  if(i%4==0)
			printf(" ");
		}
		printf(" %04X\n",x);
}

byte ascii2scan(byte car)
{
  int i;
  for(i=0;i<256;i++)
    if(scan2ascii(i)==toupper(car))
      return i;
  return 0;
}
/*
Bit16u do_tosh(Bit16u valcrc, byte car)
{
  register byte ah,al,dh,dl;
  ah=(valcrc>>8)^car;
  ah^=(ah<<4);
  al=(ah>>5)^ah;
  ah=(ah<<3)^(ah>>4)^valcrc;
  return (ah<<8)|al;
}
*/
Bit16u do_tosh(Bit16u valcrc, byte car)
{
    register byte ah,al,dh,dl;
    al=(byte)valcrc;
    ah=valcrc>>8;
    ah^=car;
    dl=ah;
    dl<<=4;
    ah^=dl;
    dl=ah;
    dl>>=5;
    dl^=ah;
    dh=ah;
    ah<<=3;
    ah^=al;
    dh>>=4;
    ah^=dh;
    al=dl;
    return (ah<<8)|al;
}

char tosh_res[11];

byte brute_tosh(Bit16u but, Bit16u valcrc, byte lng)
{
  byte p;
  //static byte const tbl_car[]={0x10,0x11,0x12,0x14,0x16};
  static byte const tbl_car[]={0x10,0x11,0x12,0x13};

  if (lng==0)
  {
	/*
    if(valcrc==0)
      valcrc++;
	  */
    return (but==valcrc);
  }
  else
  {
    for (p=0;p<sizeof(tbl_car);p++)
      if (brute_tosh(but, do_tosh(valcrc,tbl_car[p]), lng-1))
      {
		tosh_res[MAX_LENGTH_PWD-lng]=tbl_car[p];
		return 1;
	  }
  }
  return 0;
}

void aff_scan(char* chaine)
{
  int i;
  for (i=0;chaine[i];i++)
	putchar(scan2ascii(chaine[i]));
}

byte brute_toshiba(int position,Bit16u but)
{
  int i;
  byte res;
  /*
  if(but==0)
  {
    printf("[]");
    return 1;
  }
  */
  memset(tosh_res,0,sizeof(tosh_res));
  res=brute_tosh(but, 0,MAX_LENGTH_PWD);
  if(res)
  {
    putchar('[');
	aff_scan(tosh_res);
    putchar(']');
  }
  else
    printf("Echec %08X\n",but);
  printf("But %04X, but atteint %04X", but, get_CRC_scan(tosh_res));
  return res;
}

int get_CRC(char *chaine)
{
  Bit16u valcrc=0;
  while(*chaine)
  {
    valcrc=do_tosh(valcrc, ascii2scan(*chaine));
	chaine++;
  }
  return valcrc;
}

int get_CRC_scan(char *chaine)
{
  Bit16u valcrc=0;
  while(*chaine)
  {
    valcrc=do_tosh(valcrc, *chaine);
	chaine++;
  }
  return valcrc;
}

void create_comb(int but, t_tab *chaine)
{
  int valcrc;
  int i,j;
  valcrc=get_CRC(*chaine);
  for(i=0;(*chaine)[i];i++)
	(*chaine)[i]=ascii2scan((*chaine)[i]);
  for(i=0;i<16;i++)
  {
	if((valcrc&(1<<i))!=(but&(1<<i)))
	{
//	  printf("Bit %02d\n",i);
	  for(j=0;(*chaine)[j];j++)
	  {
//		printf("i %d, j %d\n",i,j);
//		printf("%c\n", *chaine[j]);
//		printf("%d\n", table[i][j]);
		(*chaine)[j]^=table[i][j];
	  }
	}
  }
  printf("\nBut %04X, but scan atteint %04X ",but, get_CRC_scan((char*)chaine));
  for(i=0;(*chaine)[i];i++)
	(*chaine)[i]=scan2ascii((*chaine)[i]);
  printf("but atteint %04X %s", get_CRC((char*)chaine),chaine);
}


int test_tosh()
{
  int i;
  for(i=0;i<0x10000;i++)
  {
    if(i%0x100==0)
      printf("Test %04X\n", i);
    if(!brute_toshiba(0,i))
      printf("Toshiba err %04X\n",i);
  }
  return 0;
}

int main()
{
  //unsigned char *chaine="AAAAAAAA";
  //t_tab chaine_but="TTAZZAEAAA";
  t_tab chaine    ="AAAAAAAA"; /* A3F6 */
  t_tab chaine_but="A";
  int i,j;
  memset(tosh_res,0,sizeof(tosh_res));
  /*
  aff_bin(get_CRC("AAAAAAAAAA"));
  aff_bin(get_CRC("AAAAAAAAAZ"));
  aff_bin(get_CRC("AAAAAAAAAE"));
  aff_bin(get_CRC("AAAAAAAAAT"));
  aff_bin(get_CRC("AAAAAAAAAO"));
  aff_bin(get_CRC("AAAAAAAAAD"));
  printf("\n");
  aff_bin(get_CRC("AAAAAAAAZA"));
  aff_bin(get_CRC("AAAAAAAAEA"));
  aff_bin(get_CRC("AAAAAAAATA"));
  aff_bin(get_CRC("AAAAAAAAOA"));
  aff_bin(get_CRC("AAAAAAAADA"));
  printf("\n");
  */
  printf("Debut\n");
  brute_toshiba(0,0);
  printf("Fin\n");
  for(i=0;i<16;i++)
  {
	printf("\n%2d ",i);
    brute_toshiba(i,get_CRC("AAAAAAAA")^(1<<i));
    putchar(' ');
    for (j=0;tosh_res[j];j++)
	{
      printf("%02X",tosh_res[j]^ascii2scan('A'));
      table[i][j]=tosh_res[j]^ascii2scan('A');
	}
  }
  printf("\n");
  create_comb(0,&chaine);
  create_comb(get_CRC("a"),&chaine);
  create_comb(get_CRC("colette"),&chaine);
  create_comb(get_CRC("colette1"),&chaine);
  return 0;
}
